const jwt = require("jsonwebtoken");
// const UserSchema = require("../models/userModel");
// const { setJwtToken, verifyJwtToken } = require("../config/jwtConfig");
const userSchema = require("../models/userModel");
const importedDataModel = require("../models/importedDataModel");

// *************-Generating OTP-*************
const sendMobileOtp = async (req, res) => {
  try {
    // ---------Sending query to the database using Mobile---------
    const user = await importedDataModel.findOne({
      mobile: String(req.body.mobile),
    });
    // ---------Exit if user not found in database---------
    if (!user) {
      return res
        .status(401)
        .json({ success: false, message: "Mobile not found." });
    }

    // ---------Sending real OTP to number---------
    const OTP = Math.floor(100000 + Math.random() * 900000).toString();
    const API = process.env.OTP_API_KEY;
    const PHONE = Number(req.body.mobile);
    const URL = `https://sms.renflair.com/V1.php?API=${API}&PHONE=${PHONE}&OTP=${OTP}`;

    const result = await fetch(URL);
    const result_data = await result.json();
    console.log("OTP API response is - ", result_data);

    // ---------Exit if there is an OTP API error---------
    if (result_data.status !== "SUCCESS") {
      return res.status(500).json({
        success: false,
        message: "Unable to send OTP to Mobile.",
      });
    }

    //----------Creating JWT Token-----------
    const data = { mobile: String(req.body.mobile) };
    const newToken = jwt.sign(data, OTP, { expiresIn: "600s" });

    console.log(OTP, " - ", data, " - ", newToken);
    return res.status(201).json({
      success: true,
      message: "OTP generated successfully",
      token: newToken,
    });
  } catch (error) {
    console.log("Catch Error - ", error);
    return res.status(500).json({
      success: false,
      message: "Can't generate OTP.",
    });
  }
};

// *************-Verifying OTP-*************
const verifyMobileOtp = (req, res) => {
  try {
    const decoded = jwt.verify(String(req.body.token), String(req.body.otp));

    // ---------Exit if Mobile inside JWT token is not same as request---------
    if (decoded.mobile !== String(req.body.mobile)) {
      return res
        .status(400)
        .json({ success: false, message: "Invalid or expired OTP" });
    }

    // --------OTP Verification Success---------
    return res
      .status(200)
      .json({ success: true, message: "OTP verified successfully" });
  } catch (error) {
    // ---------Catching Whole error---------
    // console.log(error)
    return res
      .status(400)
      .json({ success: false, message: "Invalid or expired OTP" });
  }
};

module.exports = { sendMobileOtp, verifyMobileOtp };
