const express = require("express");
const cors = require("cors");
require("dotenv").config();
const loginToken = require("./middlewares/authMiddleware");
const { connectMongoDB } = require("./connections");
const userRouter = require("./routers/userRoutes");
const otpRouter = require("./routers/otpRoutes");
// const cookieParser = require("cookie-parser");
// const login = require("./public/login");
// const signup = require("./public/signup");
// const home = require("./public/home");
// const fs = require("fs");
// const path = require("path");
// const demoModel = require("./models/demo.model");

const app = express();
const PORT = process.env.PORT || 7000;

connectMongoDB(process.env.MONGODB_URL).then(() => {
  console.log("MongoDB connected.");
});

app.use(cors());
/* app.use(cors({origin: "http://localhost:5000"})); */
app.use(express.urlencoded({ extended: false }));
app.use(express.json());
// app.use(cookieParser());

app.get("/", (req, res) => res.send("Welcome to the Server."));
app.use("/user", userRouter);
app.use("/otp", otpRouter);

// app.get("/login", (req, res) => res.send(login));
// app.get("/home", loginToken, (req, res) => res.send(home));
// app.post("/signup", async (req, res) => {
//   const body = req.body;
//   console.log(body);
//   const result = await demoModel.create({
//     name: body.name,
//     email: body.email,
//     password: body.password,
//   });
//   const uid = setJwtToken(body.name);
//   res.cookie("uid", uid);
//   res.status(201).json(result);
// });
// app.get("/signup", (req, res) => {
//   return res.send(signup);
// });

//Need to check below lines
// app.get("/home", (req, res) => {
//   const filePath = path.join(__dirname, "public", "home.html");
//   fs.readFile(filePath, "utf8", (err, data) => {
//     return res.send(data);
//   });
// });

app.listen(PORT);
