require("dotenv").config();
const jwt = require("jsonwebtoken");
const jwt_key = process.env.JWT_SECRET;

const setJwtToken = (value, expiry) => {
  // let setExpiry = expiry || process.env.JWT_EXPIRES_IN;
  return jwt.sign(value, jwt_key, { expiresIn: expiry });
};

const verifyJwtToken = (token) => {
  if (!token) return null;
  try {
    return jwt.verify(token, jwt_key);
  } catch (error) {
    return null;
  }
};

module.exports = { setJwtToken, verifyJwtToken };
