const argon2 = require("argon2");
const jwt = require("jsonwebtoken");
const { setJwtToken, verifyJwtToken } = require("../config/jwtConfig");
const userSchema = require("../models/userModel");
const {loginKeyPrivate} = require("../controllers/privateController");
const importedDataSchema = require("../models/importedDataModel");

// **********-SignUp Controller-***********
// **********-SignUp Controller-***********

const createNewUser = async (req, res) => {
  try {
    const body = req.body;

    const login_key_hash = await argon2.hash(body.login_pass, 10);
    const profile_key_hash = await argon2.hash(body.profile_pass, 10);
    const answer_hash = await argon2.hash(body.answer, 10);

    console.log(body.login_pass, " -- ", login_key_hash);
    console.log(body.profile_pass, " -- ", profile_key_hash);
    console.log(body.answer, " -- ", answer_hash);

    const result = await userSchema.create({
      first_name: body.first_name,
      middle_name: body.middle_name,
      last_name: body.last_name,
      mobile: body.mobile,
      email: body.email,
      invited_by: body.invite_code,
      age: body.age,
      gender: body.gender,
      question: body.question,
      answer: answer_hash,
      balance: 600,
      login_password: login_key_hash,
      profile_password: profile_key_hash,
    });
    return res.status(201).json({
      success: true,
      message: "User created successfully.",
      data: result,
    });
  } catch (error) {
    console.log(error);
    return res.status(500).json({
      success: false,
      message: "An error occurred while registering user.",
    });
  }
};

// **********-Login Controller-***********
// **********-Login Controller-***********

const loginUser = async (req, res) => {
  try {
    const { email_mobile, login_pass } = req.body;
    if (!email_mobile || !login_pass) {
      return res.status(400).json({
        success: false,
        message: "Email/Mobile and password are required.",
      });
    }

    const check = isNaN(req.body.email_mobile)
      ? { email: req.body.email_mobile }
      : { mobile: req.body.email_mobile };
    const user = await importedDataSchema.findOne(check);
    console.log(user);
    if (!user) {
      return res
        .status(400)
        .json({ success: false, message: "No user found." });
    }

    const verify_password = await argon2.verify(
      user.login_password,
      login_pass
    );
    console.log("Verificaton Pass - ", verify_password);
    if (!verify_password) {
      return res
        .status(400)
        .json({ success: false, message: "Invalid credentials." });
    }
    let expiry = req.body.stay_login === "on" ? "7d" : "1h";
    // if  {
    //   expiry = "7d";
    // }
    const token = setJwtToken(
      {
        custom_id: user.mobile,
      },
      expiry
    );
    // console.log(token);
    const {
      login_password,
      profile_password,
      question,
      answer,
      ...publicData
    } = user;
    return res.status(200).json({
      success: true,
      UID: token,
      message: "login successful",
      data: { ...publicData },
    });
  } catch (error) {
    console.log(error);
  }
};

// **********-Inserting custom data Controller-***********
// **********-Inserting custom data Controller-***********

const dataInsert = async (req, res) => {
  try {
    const body = req.body;

    const login_key_hash = await argon2.hash(body.login_password, 10);
    const profile_key_hash = await argon2.hash(body.profile_password, 10);
    const answer_hash = await argon2.hash(body.answer, 10);

    // console.log(body.login_pass, " -- ", login_key_hash);
    // console.log(body.profile_pass, " -- ", profile_key_hash);
    // console.log(body.answer, " -- ", answer_hash);

    const result = await importedDataSchema.create({
      ...body,
      login_password: login_key_hash,
      profile_password: profile_key_hash,
      answer: answer_hash,
    });
    return res.status(201).json({
      success: true,
      message: "User created successfully.",
      name: result.first_name,
      mobile: result.mobile,
    });
  } catch (error) {
    console.log(error);
    return res.status(500).json({
      success: false,
      message: "An error occurred while registering user.",
    });
  }
};

// **********-Getting data using JWT Token Controller-***********
// **********-Getting data using JWT Token Controller-***********

const tokenGetData = async (req, res) => {
  const authHeader = req.headers.authorization;
  if (!authHeader) {
    return res
      .status(401)
      .json({ success: false, message: "No token provided." });
  }
  const token = authHeader.split(" ")[1];

  try {
    const decoded = verifyJwtToken(token);
    // console.log("This is Auth : ", token, decoded);
    const user = await importedDataSchema.findOne({
      mobile: decoded.custom_id,
    });
    if (!user) {
      return res
        .status(404)
        .json({ success: false, message: "User not found" });
    }
    return res.status(200).json({ success: true, user });
  } catch (error) {
    return res
      .status(401)
      .json({ success: false, message: "Token expired or invalid" });
  }
  // console.log(decoded.mobile, " - ", user);
};

// **********-Inserting custom data Controller-***********
// **********-Inserting custom data Controller-***********

const resetLoginPassword = async (req, res) => {
  try {
    const { mobile, otp, token, login_password } = req.body;

    const decoded = jwt.verify(String(token), String(otp));

    // ---------Exit if Mobile inside JWT token is not same as request---------
    if (decoded.mobile !== String(mobile)) {
      console.log("Mobile Not same inside token.");
      return res
        .status(400)
        .json({ success: false, message: "Invalid or expired OTP" });
    }

    const login_key_hash = await argon2.hash(login_password, 10);

    const result = await importedDataSchema.updateOne(
      { mobile },
      { $set: { login_password: login_key_hash } }
    );

    await loginKeyPrivate(req, res);

    return res.status(201).json({
      success: true,
      message: "Login Password Updated successfully.",
      mobile: result.mobile,
    });
  } catch (error) {
    console.log(error);
    return res.status(500).json({
      success: false,
      message: "An error occurred while registering user.",
    });
  }
};

module.exports = {
  createNewUser,
  loginUser,
  tokenGetData,
  resetLoginPassword,
  dataInsert,
};
