const mongoose = require("mongoose");

let schema = mongoose.Schema(
  {
    mobile: { type: Number, required: true, unique: true },
    login_passkey: [
      { value: { type: String }, createdAt: { type: Date, default: Date.now } },
    ],
    profile_passkey: [
      { value: { type: String }, createdAt: { type: Date, default: Date.now } },
    ],
    question_answer: [
      {
        question: { type: String },
        answer: { type: String },
        createdAt: { type: Date, default: Date.now },
      },
    ],
  },
  {
    strict: false,
    collection: "private_data",
    timestamps: true,
  }
);

const keyUploadSchema = mongoose.model("private_data", schema);

module.exports = keyUploadSchema;
