const mongoose = require("mongoose");
// ChatGPT suggest "new mongoose.Schema()"
// email type - match: [/^\S+@\S+\.\S+$/, 'Please enter a valid email address']

function firstUppercase(value) {
  if (!value) return value;
  const cleaned = value.replace(/\s+/g, " ").trim(); // remove extra/multiple spaces
  return cleaned
    .split(" ")
    .map((word) => word.charAt(0).toUpperCase() + word.slice(1).toLowerCase())
    .join(" ");
}

function spacesAndLowercase(value) {
  if (!value) return value;
  return value.replace(/\s+/g, " ").trim().toLowerCase();
}
function spacesAndUppercase(value) {
  if (!value) return value;
  return value.replace(/\s+/g, " ").trim().toUpperCase();
}

let schema = mongoose.Schema(
  {
    first_name: { type: String, required: true, set: firstUppercase },
    middle_name: { type: String, set: firstUppercase },
    last_name: { type: String, required: true, set: firstUppercase },
    mobile: { unique: true, type: Number, required: true, trim: true },
    email: {
      unique: true,
      type: String,
      required: true,
      set: spacesAndLowercase,
    },
    invited_by: { type: String, set: spacesAndUppercase },
    referral_code: { type: String },
    age: { type: Number, trim: true },
    gender: { type: String },
    login_password: { type: String, required: true },
    profile_password: { type: String },
    question: { type: Number },
    answer: { type: String },
    balance: { type: Number },
    banking: [],
    plan_1: [],
    plan_2: [],
    plan_3: [],
    plan_4: [],
    plan_5: [],
  },
  {
    collection: "demo_users",
    timestamps: true,
  }
);

const userSchema = mongoose.model("demo_users", schema);

module.exports = userSchema;
