const {
  createNewUser,
  loginUser,
  tokenGetData,
  dataInsert,
  resetLoginPassword,
} = require("../controllers/userController");
const router = require("express").Router();

router.route("/signup").post(createNewUser);

router
  .route("/login")
  .post(loginUser)
  .get((req, res) => {
    return res.json({ message: "Custom GET request" });
  });

router.route("/me").get(tokenGetData);

router
  .route("/reset/login-password")
  .post(resetLoginPassword)
  .get((req, res) => res.json({ message: "Hello World." }));

router
  .route("/import-data")
  .post(dataInsert)
  .get((req, res) => res.json({ message: "Import Please" }));

module.exports = router;
